//------------------------------------------------------------------------------
// File: BridgeTutorial.cs
// Handles bridge tutorial functionality.
// Author: Michael Felice
//------------------------------------------------------------------------------


// SCENARIO CALLBACK FUNCTIONS for Bridge Tutorial

// load scenario function (initializes the bridge tutorial tasks)
function startBridgeTutorialTasks()
{
   tsStartTask("BridgeTutorial", "BridgeTutorialInit");
   tsEnableCommand("BuildCmdData", false);
   // Change lumbermill to team 1
   tsConvertObjTeam("BTwoodhut", $OST_PLAYER);
   tsConvertObjTeam("mill", $OST_PLAYER);
   
   // disable command data that should not be used in the tutorial
   tsEnableCommand(DemolishCmdData, false);
   tsEnableCommand(AttackCmdData, false);
   tsEnableCommand(RepairCmdData, false);
   
   // disable the quit scenario button
   $DisableQuitScenario = true;
      
   // remove any existing quests from the quest log
   InitializeQuestGui();
   
   // initialize quest information
   tsAddQuestToTracker(true, "Bridge Tutorial", "", "Learn how to build and cross Bridges.", "Reward: 5 Experience");
   tsAddTaskToTracker("Bridge Tutorial", "Talk to " @ btciv1.name @ ".", "Talk to " @ btciv1.name @ " to learn learn how to build Bridges.");
   tsReadyQuest("Bridge Tutorial");
}

// quit scenario function (turns off the bridge tutorial task)
function quitBridgeTutorialTasks()
{
   tsEndTask("BridgeTutorial");
}

// send dialog to the first civilian
function BridgeTutorialInit::onExit(%vertex)
{
   //First dialog box to have picture of 2nd Build Tab below text.
   tsSendTaskClickDlg("ID_TASKNAME_BRIDGETUT", "id_bridgetut_intro", $TaskButton::More, "btciv1", "id_bridgetut_intro");
}
function BridgeTutorialIntro::onExit(%vertex)
{
   //Second dialog box to have picture of Bridge Button and Bridge ready to be placed.
   tsSendTaskPopUpDlg("ID_TASKNAME_BRIDGETUT", "id_bridgetut_build", $TaskButton::Okay, "btciv1", "id_bridgetut_build");  
}

// when the first dialog is complete, add resources for bridge placement
function BridgeTutorialDialog1::onExit(%vertex)
{
   tsAddTaskToTracker("Bridge Tutorial", "Build a Bridge.", "Build a Bridge over the river.");
   tsCompleteTaskInTracker("Bridge Tutorial", "Talk to " @ btciv1.name @ ".");
   // enable build button
   tsEnableCommand("BuildCmdData", true);
   
   // give the player enough resources to build a bridge
   %gold = Bridge.goldCost;
   %wood = Bridge.woodCost;
   tsModifyResource($Resource::Gold, %gold, true);
   tsModifyResource($Resource::Wood, %wood, true);
      
   // disable all buttons except for the bridge
   ShackButton.disabled = true;
   LogcabinButton.disabled = true;
   HotelButton.disabled = true;
   WellButton.disabled = true;
   WoodhutButton.disabled = true;
   GoldMineButton.disabled = true;
   WatertowerButton.disabled = true;
   GranaryButton.disabled = true;
   GeneralButton.disabled = true;
   SaloonButton.disabled = true;
   LumbermillButton.disabled = true;
   BlacksmithButton.disabled = true;
   SheriffsOfficeButton.disabled = true;
   TradingpostButton.disabled = true;
   TownhallButton.disabled = true;
   WatchtowerButton.disabled = true;
   GazeboButton.disabled = true;
   ChurchButton.disabled = true;
   BarbershopButton.disabled = true;
   OuthouseButton.disabled = true;
   WelcomesignButton.disabled = true;
   FountainButton.disabled = true;
   TownbellButton.disabled = true;
   FlowerpotButton.disabled = true;
}

// after the first bridge is placed, display a quick dialog
function BridgeTutorialPlace1::onExit(%vertex)
{
   tsAddTaskToTracker("Bridge Tutorial", "Cross the Bridge.", "Move " @ HeroCharacter.name @ " across the Bridge that you just built.");
   tsCompleteTaskInTracker("Bridge Tutorial", "Build a Bridge.");
   
   tsSendTaskPopUpDlg("IS_TASKNAME_BRIDGETUT", "id_bridgetutorial_cross", $TaskButton::Okay, "btciv1");
   
   BlacksmithButton.disabled = true;
   TownhallButton.disabled = true;   
   ChurchButton.disabled = true;
   HotelButton.disabled = true;
   WoodhutButton.disabled = true;
   WellButton.disabled = true;
   LumbermillButton.disabled = true;
}

// after the first bridge is crossed, send dialog to the second civilian
function BridgeTutorialCross1::onExit(%vertex)
{
   tsAddTaskToTracker("Bridge Tutorial", "Talk to " @ btciv2.name @ ".",
      "Talk to " @ btciv2.name @ "to learn more about building Bridges.");
   tsCompleteTaskInTracker("Bridge Tutorial", "Cross the Bridge.");
   
   tsSendTaskPopUpDlg("ID_TASKNAME_BRIDGETUT", "id_bridgetut_place", $TaskButton::More, "btciv2", "id_bridgetut_place");
   
   if(firstword(getRes()) > 800)
   {
      %imagePos = "45 65";
   }
   else
   {
      %imagePos = "35 51";
   }
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/buildingarrowup.png";
      iconOffset = "0 0";
      extent = "59 59";
      position = %imagePos;
      input = "0";
      onTop = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_BRIDGETUT", false, $TaskButton::Okay, "id_bridgetut_placetwo");
   tsAddTaskDialog("id_bridgetut_placetwo", %dlgData);
   tsSetTaskDialogImage(%image1, %dlgData);
   tsSendTaskDlgMsg(%dlgData, "btciv2");
   tsDestroyTaskDlgData(%dlgData);
   
}

function BridgeTutorialDialog2::onExit(%vertex)
{
   // Quest log   
   tsAddTaskToTracker("Bridge Tutorial", "Build a Rotated Bridge.", "Build a Bridge across the river to the northeast by rotating it before it's placed.");
   tsAddTaskToTracker("Bridge Tutorial", "Cross the northeast Bridge.", "Move " @ HeroCharacter.name @ " across the river to the northeast.");
   tsCompleteTaskInTracker("Bridge Tutorial", "Talk to " @ btciv2.name @ ".");
   
   // give the player enough resources to build a bridge
   %gold = Bridge.goldCost;
   %wood = Bridge.woodCost;
   tsModifyResource($Resource::Gold, %gold, true);
   tsModifyResource($Resource::Wood, %wood, true);
}

// checks if the second bridge is properly placed:
// if bridge is not properly placed (wait for another bridge to be placed)
// if bridge is properly placed (move to the next step-- crossing the bridge)
function BridgeTutorialPlace2::onExit(%vertex)
{
   // check if the hero can get to the opposite side
   %position = btciv3.position;
   if (IsSameRegion(btciv2, getWord(%position, 0),
      getWord(%position, 1)) == false)
   {
      // if the other side is a different region, more text needs
      // to happen, so the bridge is placed in the proper place
      schedule(100, 0, "BridgeTutorialPlaceAgain");
   }
   // activate the task since the destination can be reached
   else
   {
      tsCompleteTaskInTracker("Bridge Tutorial", "Build a Rotated Bridge.");
      TaskModifier.strMarkVertex("BridgeTutorial", "BridgeTutorialCross2", $TSV_AVAIL);
   }
   
   BlacksmithButton.disabled = true;
   TownhallButton.disabled = true;   
   ChurchButton.disabled = true;
   HotelButton.disabled = true;
   WoodhutButton.disabled = true;
   WellButton.disabled = true;
   LumbermillButton.disabled = true;
}

// this function is called when the second bridge was placed in the
// wrong location (and hero cannot get across the water), so give
// a new message and reactivate the task
function BridgeTutorialPlaceAgain()
{
   // reset the dialog task that give money activates
   // crossing the second bridge
   TaskModifier.strResetVertex("BridgeTutorial", "BridgeTutorialPlace2");
   TaskModifier.strMarkVertex("BridgeTutorial", "BridgeTutorialPlace2", $TSV_AVAIL);
   
   %gold = Bridge.goldCost;
   %wood = Bridge.woodCost;
   tsModifyResource($Resource::Gold, %gold, true);
   tsModifyResource($Resource::Wood, %wood, true);
   
   TownhallButton.disabled = true;   
   ChurchButton.disabled = true;
   HotelButton.disabled = true;
   WoodhutButton.disabled = true;
   WellButton.disabled = true;
   LumbermillButton.disabled = true;
   
   // send the second dialog again
   tsSendTaskClickDlg("ID_TASKNAME_BRIDGETUT", "id_bridgetut_placeagain", $TaskButton::Okay, "btciv2", "id_bridgetut_place");
}

// after the second bridge is crossed, send dialog to third civilian
function BridgeTutorialCross2::onExit(%vertex)
{
   tsAddTaskToTracker("Bridge Tutorial", "Talk to " @ btciv3.name @ ".", "Cross the Bridge to talk to " @ btciv3.name @ " and pick up " @ btciv2.name @ "'s delivery.");
   tsCompleteTaskInTracker("Bridge Tutorial", "Cross the northeast Bridge.");
   
   tsSendTaskClickDlg("ID_TASKNAME_BRIDGETUT", "id_bridgetut_pickupcrate",
      $TaskButton::Okay, "btciv3", "id_bridgetut_pickupcrate");
}

// once the tutorial crate dialog is completed, make the crate pickup availale
function BridgeTutorialDialog4::onExit(%vertex)
{
   tsAddTaskToTracker("Bridge Tutorial", "Pick up the Crate.",
      "Pick up the Crate containing " @ btciv2.name @ "'s delivery.");
   tsAddTaskToTracker("Bridge Tutorial", "Take the delivery back to " @ btciv2.name @ ".",
      "Bring " @ btciv2.name @ "'s delivery back to him.");
   tsCompleteTaskInTracker("Bridge Tutorial", "Talk to " @ btciv3.name @ ".");
   
   // unhide the pickup crate
   %crateobj = tsCreateObj("cratepickup", "crate", "-1", "-409 -385", "crate");   
   
}

// the crate is picked up, task vertices handle the rest
function BridgeTutorialCrate::onExit(%vertex)
{
   tsCompleteTaskInTracker("Bridge Tutorial", "Pick up the Crate.");
}

// we have gotten back to the character with the crate, and we are done!
function BridgeTutorialCross3::onExit(%vertex)
{
   // quest is complete
   tsCompleteTaskInTracker("Bridge Tutorial", "Take the delivery back to " @ btciv2.name @ ".");
   tsSendTaskClickDlg("ID_TASKNAME_BRIDGETUT", "id_bridgetut_done",
      $TaskButton::Accept, "btciv2", "id_bridgetut_done");
   
   // experience reward for completing the quest
   tsModifyResource($Resource::Experience, 5, true);
   SendProductionToClient(HeroCharacter, "5 experience");
}

// bridge tutorial complete, return to main map
function BridgeTutorialDone::onExit(%vertex)
{
   // return from this satellite
   %scenario = new SLScenario()
   {
        stack = false;
   };
   LoadScenario(%scenario);
}
